/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import processing.core.PApplet;
import processing.core.PVector;

public class MIT4_112F12_Code_Ex1_JB
extends PApplet {
    int numBall = 200;
    World world;

    public void createWorld() {
        int n = 0;
        while (n < this.numBall) {
            PVector pVector = new PVector(this.random(0.0f, this.width), this.random(0.0f, this.height));
            PVector pVector2 = new PVector(this.random(0.5f), this.random(0.5f));
            int n2 = this.color(0.0f, 0.0f, 0.0f, this.random(150.0f, 255.0f));
            float f = 3.0f;
            Ball ball = new Ball(pVector, pVector2, n2, f);
            this.world.addBall(ball);
            ++n;
        }
    }

    public void setup() {
        this.size(800, 600, "processing.core.PGraphics3D");
        this.smooth();
        this.world = new World();
        this.createWorld();
    }

    public void draw() {
        this.background(255);
        this.world.update();
        this.world.connectivity();
        this.world.run();
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--bgcolor=#FFFFFF", "MIT4_112F12_Code_Ex1_JB"});
    }

    class Ball {
        PVector loc;
        PVector vel;
        float dim;
        int col;
        float damping = 0.005f;
        float maxSpeed = 1.0f;

        Ball(PVector pVector, PVector pVector2, int n, float f) {
            this.loc = pVector;
            this.vel = pVector2;
            this.col = n;
            this.dim = f;
        }

        public void moveBall() {
            PVector pVector = new PVector(this.vel.x, this.vel.y);
            if (pVector.mag() > this.maxSpeed) {
                pVector.mult(pVector.mag() * pVector.mag() * this.damping);
                this.vel.sub(pVector);
            }
            this.loc.add(this.vel);
        }

        public void boundary() {
            if (this.loc.x > (float)MIT4_112F12_Code_Ex1_JB.this.width || this.loc.x < 0.0f) {
                this.vel.x *= -1.0f;
            }
            if (this.loc.y > (float)MIT4_112F12_Code_Ex1_JB.this.height || this.loc.y < 0.0f) {
                this.vel.y *= -1.0f;
            }
        }

        public void display() {
            MIT4_112F12_Code_Ex1_JB.this.noStroke();
            MIT4_112F12_Code_Ex1_JB.this.fill(this.col);
            MIT4_112F12_Code_Ex1_JB.this.ellipse(this.loc.x, this.loc.y, this.dim, this.dim);
        }
    }

    class World {
        ArrayList<Ball> balls = new ArrayList();
        PVector pos;
        float magnetism;

        World() {
        }

        public void addBall(Ball ball) {
            this.balls.add(ball);
        }

        public void update() {
            int n = 0;
            while (n < this.balls.size()) {
                this.balls.get(n).moveBall();
                this.balls.get(n).boundary();
                ++n;
            }
        }

        public void connectivity() {
            int n = 0;
            while (n < this.balls.size()) {
                Ball ball = this.balls.get(n);
                PVector pVector = this.balls.get((int)n).loc;
                int n2 = 0;
                while (n2 < this.balls.size()) {
                    this.balls.get(n2);
                    PVector pVector2 = this.balls.get((int)n2).loc;
                    if (pVector.dist(pVector2) < 50.0f) {
                        MIT4_112F12_Code_Ex1_JB.this.strokeWeight(2.0f);
                        MIT4_112F12_Code_Ex1_JB.this.stroke(40, 90.0f);
                        MIT4_112F12_Code_Ex1_JB.this.line(pVector.x, pVector.y, pVector2.x, pVector2.y);
                    }
                    if (pVector.dist(pVector2) < 100.0f && pVector.dist(pVector2) > 50.0f) {
                        MIT4_112F12_Code_Ex1_JB.this.strokeWeight(2.0f);
                        MIT4_112F12_Code_Ex1_JB.this.stroke(120, 50.0f);
                        MIT4_112F12_Code_Ex1_JB.this.line(pVector.x, pVector.y, pVector2.x, pVector2.y);
                    }
                    if (pVector.dist(pVector2) < 150.0f && pVector.dist(pVector2) > 100.0f) {
                        MIT4_112F12_Code_Ex1_JB.this.strokeWeight(1.0f);
                        MIT4_112F12_Code_Ex1_JB.this.stroke(180, 50.0f);
                        MIT4_112F12_Code_Ex1_JB.this.line(pVector.x, pVector.y, pVector2.x, pVector2.y);
                    }
                    if (pVector.dist(pVector2) < 200.0f && pVector.dist(pVector2) > 200.0f) {
                        MIT4_112F12_Code_Ex1_JB.this.strokeWeight(1.0f);
                        MIT4_112F12_Code_Ex1_JB.this.stroke(200, 40.0f);
                        MIT4_112F12_Code_Ex1_JB.this.line(pVector.x, pVector.y, pVector2.x, pVector2.y);
                    }
                    this.pos = new PVector(pVector.x, pVector.y);
                    this.magnetism = 0.005f;
                    PVector pVector3 = new PVector((float)MIT4_112F12_Code_Ex1_JB.this.mouseX, (float)MIT4_112F12_Code_Ex1_JB.this.mouseY);
                    pVector3.sub(this.pos);
                    float f = pVector3.mag();
                    if (f < 100.0f && f > 5.0f) {
                        ball.maxSpeed = 0.0f;
                        ball.damping = 0.05f;
                        pVector3.mult(this.magnetism);
                        pVector3.mult(1.0f / f / f);
                        ball.vel.add(pVector3);
                    } else {
                        ball.damping = 0.005f;
                        ball.maxSpeed = 1.0f;
                    }
                    ++n2;
                }
                ++n;
            }
        }

        public void run() {
            int n = 0;
            while (n < this.balls.size()) {
                this.balls.get(n).display();
                ++n;
            }
        }
    }
}

