/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import java.util.ArrayList;
import javax.media.opengl.GLAnimatorControl;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLRunnable;
import jogamp.opengl.Debug;

public class GLDrawableUtil {
    protected static final boolean DEBUG = Debug.debug("GLDrawable");
    static GLRunnable setViewport = new GLRunnable(){

        @Override
        public boolean run(GLAutoDrawable gLAutoDrawable) {
            gLAutoDrawable.getGL().glViewport(0, 0, gLAutoDrawable.getWidth(), gLAutoDrawable.getHeight());
            return true;
        }
    };
    static GLRunnable glFinish = new GLRunnable(){

        @Override
        public boolean run(GLAutoDrawable gLAutoDrawable) {
            gLAutoDrawable.getGL().glFinish();
            return true;
        }
    };

    public static final boolean isAnimatorStartedOnOtherThread(GLAnimatorControl gLAnimatorControl) {
        return null != gLAnimatorControl ? gLAnimatorControl.isStarted() && gLAnimatorControl.getThread() != Thread.currentThread() : false;
    }

    public static final boolean isAnimatorStarted(GLAnimatorControl gLAnimatorControl) {
        return null != gLAnimatorControl ? gLAnimatorControl.isStarted() : false;
    }

    public static final boolean isAnimatorAnimatingOnOtherThread(GLAnimatorControl gLAnimatorControl) {
        return null != gLAnimatorControl ? gLAnimatorControl.isAnimating() && gLAnimatorControl.getThread() != Thread.currentThread() : false;
    }

    public static final boolean isAnimatorAnimating(GLAnimatorControl gLAnimatorControl) {
        return null != gLAnimatorControl ? gLAnimatorControl.isAnimating() : false;
    }

    public static final void moveGLEventListener(GLAutoDrawable gLAutoDrawable, GLAutoDrawable gLAutoDrawable2, GLEventListener gLEventListener, boolean bl) {
        boolean bl2 = gLAutoDrawable.getGLEventListenerInitState(gLEventListener);
        gLAutoDrawable.removeGLEventListener(gLEventListener);
        gLAutoDrawable2.addGLEventListener(gLEventListener);
        if (bl && bl2) {
            gLAutoDrawable2.setGLEventListenerInitState(gLEventListener, true);
            gLAutoDrawable2.invoke(false, new ReshapeGLEventListener(gLEventListener));
        }
    }

    public static final void moveAllGLEventListener(GLAutoDrawable gLAutoDrawable, GLAutoDrawable gLAutoDrawable2, boolean bl) {
        for (int i = gLAutoDrawable.getGLEventListenerCount(); 0 < i; --i) {
            GLEventListener gLEventListener = gLAutoDrawable.getGLEventListener(0);
            GLDrawableUtil.moveGLEventListener(gLAutoDrawable, gLAutoDrawable2, gLEventListener, bl);
        }
    }

    public static final void swapGLContextAndAllGLEventListener(GLAutoDrawable gLAutoDrawable, GLAutoDrawable gLAutoDrawable2) {
        GLEventListener gLEventListener;
        int n;
        GLEventListener[] gLEventListenerArray;
        int n2;
        ArrayList<GLRunnable> arrayList = new ArrayList<GLRunnable>();
        ArrayList<GLRunnable> arrayList2 = new ArrayList<GLRunnable>();
        GLAnimatorControl gLAnimatorControl = gLAutoDrawable.getAnimator();
        GLAnimatorControl gLAnimatorControl2 = gLAutoDrawable2.getAnimator();
        boolean bl = GLDrawableUtil.isAnimatorAnimatingOnOtherThread(gLAnimatorControl) && gLAnimatorControl.pause();
        boolean bl2 = GLDrawableUtil.isAnimatorAnimatingOnOtherThread(gLAnimatorControl2) && gLAnimatorControl2.pause();
        int n3 = gLAutoDrawable.getGLEventListenerCount();
        GLEventListener[] gLEventListenerArray2 = new GLEventListener[n3];
        boolean[] blArray = new boolean[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            gLEventListenerArray = gLAutoDrawable.getGLEventListener(0);
            blArray[n2] = gLAutoDrawable.getGLEventListenerInitState((GLEventListener)gLEventListenerArray);
            gLEventListenerArray2[n2] = gLAutoDrawable.removeGLEventListener((GLEventListener)gLEventListenerArray);
        }
        n2 = gLAutoDrawable2.getGLEventListenerCount();
        gLEventListenerArray = new GLEventListener[n2];
        boolean[] blArray2 = new boolean[n2];
        for (n = 0; n < n2; ++n) {
            gLEventListener = gLAutoDrawable2.getGLEventListener(0);
            blArray2[n] = gLAutoDrawable2.getGLEventListenerInitState(gLEventListener);
            gLEventListenerArray[n] = gLAutoDrawable2.removeGLEventListener(gLEventListener);
        }
        gLAutoDrawable.invoke(true, glFinish);
        gLAutoDrawable2.invoke(true, glFinish);
        gLAutoDrawable2.setContext(gLAutoDrawable.setContext(gLAutoDrawable2.getContext()));
        arrayList.add(setViewport);
        arrayList2.add(setViewport);
        for (n = 0; n < n3; ++n) {
            if (!blArray[n]) continue;
            arrayList2.add(new ReshapeGLEventListener(gLEventListenerArray2[n]));
        }
        for (n = 0; n < n2; ++n) {
            if (!blArray2[n]) continue;
            arrayList.add(new ReshapeGLEventListener(gLEventListenerArray[n]));
        }
        arrayList.add(glFinish);
        arrayList2.add(glFinish);
        gLAutoDrawable.invoke(true, arrayList);
        gLAutoDrawable2.invoke(true, arrayList2);
        for (n = 0; n < n2; ++n) {
            gLEventListener = gLEventListenerArray[n];
            gLAutoDrawable.addGLEventListener(gLEventListener);
            if (!blArray2[n]) continue;
            gLAutoDrawable.setGLEventListenerInitState(gLEventListener, true);
        }
        for (n = 0; n < n3; ++n) {
            gLEventListener = gLEventListenerArray2[n];
            gLAutoDrawable2.addGLEventListener(gLEventListener);
            if (!blArray[n]) continue;
            gLAutoDrawable2.setGLEventListenerInitState(gLEventListener, true);
        }
        if (bl) {
            gLAnimatorControl.resume();
        }
        if (bl2) {
            gLAnimatorControl2.resume();
        }
    }

    public static final void swapGLContext(GLAutoDrawable gLAutoDrawable, GLAutoDrawable gLAutoDrawable2) {
        int n;
        GLAnimatorControl gLAnimatorControl = gLAutoDrawable.getAnimator();
        GLAnimatorControl gLAnimatorControl2 = gLAutoDrawable2.getAnimator();
        boolean bl = GLDrawableUtil.isAnimatorAnimatingOnOtherThread(gLAnimatorControl) && gLAnimatorControl.pause();
        boolean bl2 = GLDrawableUtil.isAnimatorAnimatingOnOtherThread(gLAnimatorControl2) && gLAnimatorControl2.pause();
        for (n = gLAutoDrawable.getGLEventListenerCount() - 1; 0 <= n; --n) {
            gLAutoDrawable.disposeGLEventListener(gLAutoDrawable.getGLEventListener(n), false);
        }
        for (n = gLAutoDrawable2.getGLEventListenerCount() - 1; 0 <= n; --n) {
            gLAutoDrawable2.disposeGLEventListener(gLAutoDrawable2.getGLEventListener(n), false);
        }
        gLAutoDrawable2.setContext(gLAutoDrawable.setContext(gLAutoDrawable2.getContext()));
        gLAutoDrawable.invoke(true, setViewport);
        gLAutoDrawable2.invoke(true, setViewport);
        if (bl) {
            gLAnimatorControl.resume();
        }
        if (bl2) {
            gLAnimatorControl2.resume();
        }
    }

    private static class ReshapeGLEventListener
    implements GLRunnable {
        private GLEventListener listener;

        ReshapeGLEventListener(GLEventListener gLEventListener) {
            this.listener = gLEventListener;
        }

        @Override
        public boolean run(GLAutoDrawable gLAutoDrawable) {
            this.listener.reshape(gLAutoDrawable, 0, 0, gLAutoDrawable.getWidth(), gLAutoDrawable.getHeight());
            return true;
        }
    }
}

