/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.opengl.util.AnimatorBase;
import java.util.Timer;
import java.util.TimerTask;
import javax.media.opengl.GLAutoDrawable;

public class FPSAnimator
extends AnimatorBase {
    private Timer timer = null;
    private TimerTask task = null;
    private int fps;
    private boolean scheduleAtFixedRate;
    private volatile boolean shouldRun;

    @Override
    protected String getBaseName(String string) {
        return "FPS" + string + "Animator";
    }

    public FPSAnimator(int n) {
        this(null, n);
    }

    public FPSAnimator(int n, boolean bl) {
        this(null, n, bl);
    }

    public FPSAnimator(GLAutoDrawable gLAutoDrawable, int n) {
        this(gLAutoDrawable, n, false);
    }

    public FPSAnimator(GLAutoDrawable gLAutoDrawable, int n, boolean bl) {
        this.fps = n;
        if (gLAutoDrawable != null) {
            this.add(gLAutoDrawable);
        }
        this.scheduleAtFixedRate = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isStarted() {
        this.stateSync.lock();
        try {
            boolean bl = this.timer != null;
            return bl;
        }
        finally {
            this.stateSync.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isAnimating() {
        this.stateSync.lock();
        try {
            boolean bl = this.timer != null && this.task != null;
            return bl;
        }
        finally {
            this.stateSync.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isPaused() {
        this.stateSync.lock();
        try {
            boolean bl = this.timer != null && this.task == null;
            return bl;
        }
        finally {
            this.stateSync.unlock();
        }
    }

    private void startTask() {
        if (null != this.task) {
            return;
        }
        long l = (long)(1000.0f / (float)this.fps);
        this.task = new TimerTask(){

            @Override
            public void run() {
                if (FPSAnimator.this.shouldRun) {
                    FPSAnimator.this.animThread = Thread.currentThread();
                    FPSAnimator.this.display();
                }
            }
        };
        this.fpsCounter.resetFPSCounter();
        this.shouldRun = true;
        if (this.scheduleAtFixedRate) {
            this.timer.scheduleAtFixedRate(this.task, 0L, l);
        } else {
            this.timer.schedule(this.task, 0L, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean start() {
        if (this.timer != null) {
            return false;
        }
        this.stateSync.lock();
        try {
            this.timer = new Timer();
            this.startTask();
        }
        finally {
            this.stateSync.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean stop() {
        if (this.timer == null) {
            return false;
        }
        this.stateSync.lock();
        try {
            this.shouldRun = false;
            if (null != this.task) {
                this.task.cancel();
                this.task = null;
            }
            if (null != this.timer) {
                this.timer.cancel();
                this.timer = null;
            }
            this.animThread = null;
            try {
                long l = 2L * (long)(1000.0f / (float)this.fps);
                Thread.sleep(l > 20L ? l : 20L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        finally {
            this.stateSync.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean pause() {
        if (this.timer == null) {
            return false;
        }
        this.stateSync.lock();
        try {
            this.shouldRun = false;
            if (null != this.task) {
                this.task.cancel();
                this.task = null;
            }
            this.animThread = null;
            try {
                long l = 2L * (long)(1000.0f / (float)this.fps);
                Thread.sleep(l > 20L ? l : 20L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        finally {
            this.stateSync.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean resume() {
        if (this.timer == null) {
            return false;
        }
        this.stateSync.lock();
        try {
            this.startTask();
        }
        finally {
            this.stateSync.unlock();
        }
        return true;
    }
}

