/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.x11.glx;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.nativewindow.x11.X11GraphicsConfiguration;
import com.jogamp.nativewindow.x11.X11GraphicsDevice;
import com.jogamp.nativewindow.x11.X11GraphicsScreen;
import java.nio.IntBuffer;
import javax.media.nativewindow.CapabilitiesImmutable;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.VisualIDHolder;
import javax.media.opengl.DefaultGLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.nativewindow.x11.X11Lib;
import jogamp.nativewindow.x11.XRenderDirectFormat;
import jogamp.nativewindow.x11.XRenderPictFormat;
import jogamp.nativewindow.x11.XVisualInfo;
import jogamp.opengl.GLGraphicsConfigurationUtil;
import jogamp.opengl.x11.glx.GLX;
import jogamp.opengl.x11.glx.X11GLCapabilities;
import jogamp.opengl.x11.glx.X11GLXDrawableFactory;

public class X11GLXGraphicsConfiguration
extends X11GraphicsConfiguration
implements Cloneable {
    public static final int MAX_ATTRIBS = 128;
    private GLCapabilitiesChooser chooser;

    X11GLXGraphicsConfiguration(X11GraphicsScreen x11GraphicsScreen, X11GLCapabilities x11GLCapabilities, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser) {
        super(x11GraphicsScreen, x11GLCapabilities, gLCapabilitiesImmutable, x11GLCapabilities.getXVisualInfo());
        this.chooser = gLCapabilitiesChooser;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    public final long getFBConfig() {
        return ((X11GLCapabilities)this.capabilitiesChosen).getFBConfig();
    }

    public final int getFBConfigID() {
        return ((X11GLCapabilities)this.capabilitiesChosen).getFBConfigID();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void updateGraphicsConfiguration() {
        CapabilitiesImmutable capabilitiesImmutable = this.getChosenCapabilities();
        if (!(capabilitiesImmutable instanceof X11GLCapabilities) || 0 == capabilitiesImmutable.getVisualID(VisualIDHolder.VIDType.X11_XVISUAL)) {
            X11GLXGraphicsConfiguration x11GLXGraphicsConfiguration = (X11GLXGraphicsConfiguration)GraphicsConfigurationFactory.getFactory(this.getScreen().getDevice(), capabilitiesImmutable).chooseGraphicsConfiguration(capabilitiesImmutable, this.getRequestedCapabilities(), this.chooser, this.getScreen(), 0);
            if (null == x11GLXGraphicsConfiguration) throw new GLException("No native VisualID pre-chosen and update failed: " + this);
            this.setXVisualInfo(x11GLXGraphicsConfiguration.getXVisualInfo());
            this.setChosenCapabilities(x11GLXGraphicsConfiguration.getChosenCapabilities());
            if (!DEBUG) return;
            System.err.println("X11GLXGraphicsConfiguration.updateGraphicsConfiguration updated:" + this);
            return;
        } else {
            if (!DEBUG) return;
            System.err.println("X11GLXGraphicsConfiguration.updateGraphicsConfiguration kept:" + this);
        }
    }

    static X11GLXGraphicsConfiguration create(GLProfile gLProfile, X11GraphicsScreen x11GraphicsScreen, int n) {
        X11GLXDrawableFactory x11GLXDrawableFactory;
        X11GLCapabilities x11GLCapabilities;
        X11GraphicsDevice x11GraphicsDevice = (X11GraphicsDevice)x11GraphicsScreen.getDevice();
        long l = x11GraphicsDevice.getHandle();
        if (0L == l) {
            throw new GLException("Display null of " + x11GraphicsScreen);
        }
        int n2 = x11GraphicsScreen.getIndex();
        long l2 = X11GLXGraphicsConfiguration.glXFBConfigID2FBConfig(l, n2, n);
        if (0L == l2) {
            throw new GLException("FBConfig null of " + X11GLXGraphicsConfiguration.toHexString(n));
        }
        if (null == gLProfile) {
            gLProfile = GLProfile.getDefault(x11GraphicsScreen.getDevice());
        }
        if (null == (x11GLCapabilities = X11GLXGraphicsConfiguration.GLXFBConfig2GLCapabilities(x11GraphicsDevice, gLProfile, l2, 15, (x11GLXDrawableFactory = (X11GLXDrawableFactory)GLDrawableFactory.getDesktopFactory()).isGLXMultisampleAvailable(x11GraphicsDevice)))) {
            throw new GLException("GLCapabilities null of " + X11GLXGraphicsConfiguration.toHexString(l2));
        }
        return new X11GLXGraphicsConfiguration(x11GraphicsScreen, x11GLCapabilities, x11GLCapabilities, new DefaultGLCapabilitiesChooser());
    }

    static IntBuffer GLCapabilities2AttribList(GLCapabilitiesImmutable gLCapabilitiesImmutable, boolean bl, boolean bl2, long l, int n) {
        int n2 = gLCapabilitiesImmutable.getRedBits() + gLCapabilitiesImmutable.getGreenBits() + gLCapabilitiesImmutable.getBlueBits();
        if (n2 < 15) {
            throw new GLException("Bit depths < 15 (i.e., non-true-color) not supported");
        }
        IntBuffer intBuffer = Buffers.newDirectIntBuffer((int)128);
        int n3 = 0;
        if (bl) {
            int n4;
            intBuffer.put(n3++, 32784);
            if (gLCapabilitiesImmutable.isOnscreen()) {
                n4 = 1;
            } else if (gLCapabilitiesImmutable.isFBO()) {
                n4 = 1;
            } else if (gLCapabilitiesImmutable.isPBuffer()) {
                n4 = 4;
            } else if (gLCapabilitiesImmutable.isBitmap()) {
                n4 = 2;
            } else {
                throw new GLException("no surface type set in caps: " + gLCapabilitiesImmutable);
            }
            intBuffer.put(n3++, n4);
            intBuffer.put(n3++, 32785);
            intBuffer.put(n3++, 1);
        } else {
            intBuffer.put(n3++, 4);
        }
        if (bl) {
            intBuffer.put(n3++, 5);
            intBuffer.put(n3++, gLCapabilitiesImmutable.getDoubleBuffered() ? 1 : 0);
            intBuffer.put(n3++, 6);
            intBuffer.put(n3++, gLCapabilitiesImmutable.getStereo() ? 1 : 0);
            intBuffer.put(n3++, 35);
            intBuffer.put(n3++, 32768);
        } else {
            if (gLCapabilitiesImmutable.getDoubleBuffered()) {
                intBuffer.put(n3++, 5);
            }
            if (gLCapabilitiesImmutable.getStereo()) {
                intBuffer.put(n3++, 6);
            }
        }
        intBuffer.put(n3++, 8);
        intBuffer.put(n3++, gLCapabilitiesImmutable.getRedBits());
        intBuffer.put(n3++, 9);
        intBuffer.put(n3++, gLCapabilitiesImmutable.getGreenBits());
        intBuffer.put(n3++, 10);
        intBuffer.put(n3++, gLCapabilitiesImmutable.getBlueBits());
        if (gLCapabilitiesImmutable.getAlphaBits() > 0) {
            intBuffer.put(n3++, 11);
            intBuffer.put(n3++, gLCapabilitiesImmutable.getAlphaBits());
        }
        if (gLCapabilitiesImmutable.getStencilBits() > 0) {
            intBuffer.put(n3++, 13);
            intBuffer.put(n3++, gLCapabilitiesImmutable.getStencilBits());
        }
        intBuffer.put(n3++, 12);
        intBuffer.put(n3++, gLCapabilitiesImmutable.getDepthBits());
        if (gLCapabilitiesImmutable.getAccumRedBits() > 0 || gLCapabilitiesImmutable.getAccumGreenBits() > 0 || gLCapabilitiesImmutable.getAccumBlueBits() > 0 || gLCapabilitiesImmutable.getAccumAlphaBits() > 0) {
            intBuffer.put(n3++, 14);
            intBuffer.put(n3++, gLCapabilitiesImmutable.getAccumRedBits());
            intBuffer.put(n3++, 15);
            intBuffer.put(n3++, gLCapabilitiesImmutable.getAccumGreenBits());
            intBuffer.put(n3++, 16);
            intBuffer.put(n3++, gLCapabilitiesImmutable.getAccumBlueBits());
            intBuffer.put(n3++, 17);
            intBuffer.put(n3++, gLCapabilitiesImmutable.getAccumAlphaBits());
        }
        if (bl2 && gLCapabilitiesImmutable.getSampleBuffers()) {
            intBuffer.put(n3++, 100000);
            intBuffer.put(n3++, 1);
            intBuffer.put(n3++, 100001);
            intBuffer.put(n3++, gLCapabilitiesImmutable.getNumSamples());
        }
        if (gLCapabilitiesImmutable.isPBuffer() && gLCapabilitiesImmutable.getPbufferFloatingPointBuffers()) {
            String string = GLX.glXQueryExtensionsString(l, n);
            if (string == null || string.indexOf("GLX_NV_float_buffer") < 0) {
                throw new GLException("Floating-point pbuffers on X11 currently require NVidia hardware: " + string);
            }
            intBuffer.put(n3++, 8368);
            intBuffer.put(n3++, 1);
        }
        intBuffer.put(n3++, 0);
        return intBuffer;
    }

    static boolean GLXFBConfigIDValid(long l, int n, int n2) {
        long l2 = X11GLXGraphicsConfiguration.glXFBConfigID2FBConfig(l, n, n2);
        return 0L != l2 ? X11GLXGraphicsConfiguration.GLXFBConfigValid(l, l2) : false;
    }

    static boolean GLXFBConfigValid(long l, long l2) {
        IntBuffer intBuffer = Buffers.newDirectIntBuffer((int)1);
        return 2 != GLX.glXGetFBConfigAttrib(l, l2, 32785, intBuffer);
    }

    static int FBCfgDrawableTypeBits(X11GraphicsDevice x11GraphicsDevice, long l) {
        int n = 0;
        IntBuffer intBuffer = Buffers.newDirectIntBuffer((int)1);
        int n2 = X11GLXGraphicsConfiguration.glXGetFBConfig(x11GraphicsDevice.getHandle(), l, 32784, intBuffer);
        if (0 != (n2 & 1)) {
            n |= 9;
        }
        if (0 != (n2 & 2)) {
            n |= 2;
        }
        if (0 != (n2 & 4)) {
            n |= 4;
        }
        return n;
    }

    static XRenderDirectFormat XVisual2XRenderMask(long l, long l2) {
        XRenderPictFormat xRenderPictFormat = X11Lib.XRenderFindVisualFormat(l, l2);
        if (null == xRenderPictFormat) {
            return null;
        }
        return xRenderPictFormat.getDirect();
    }

    static X11GLCapabilities GLXFBConfig2GLCapabilities(X11GraphicsDevice x11GraphicsDevice, GLProfile gLProfile, long l, int n, boolean bl) {
        int n2 = X11GLXGraphicsConfiguration.FBCfgDrawableTypeBits(x11GraphicsDevice, l);
        int n3 = n & n2;
        long l2 = x11GraphicsDevice.getHandle();
        int n4 = X11GLXGraphicsConfiguration.glXFBConfig2FBConfigID(l2, l);
        XVisualInfo xVisualInfo = GLX.glXGetVisualFromFBConfig(l2, l);
        if (null == xVisualInfo) {
            if (DEBUG) {
                System.err.println("X11GLXGraphicsConfiguration.GLXFBConfig2GLCapabilities: Null XVisualInfo for FBConfigID 0x" + Integer.toHexString(n4));
            }
            n3 &= 0xFFFFFFF6;
        }
        if (0 == n3) {
            return null;
        }
        IntBuffer intBuffer = Buffers.newDirectIntBuffer((int)1);
        if (2 == GLX.glXGetFBConfigAttrib(l2, l, 32785, intBuffer)) {
            return null;
        }
        if (0 == (1 & intBuffer.get(0))) {
            return null;
        }
        X11GLCapabilities x11GLCapabilities = new X11GLCapabilities(xVisualInfo, l, n4, gLProfile);
        if (bl) {
            x11GLCapabilities.setSampleBuffers(X11GLXGraphicsConfiguration.glXGetFBConfig(l2, l, 100000, intBuffer) != 0);
            x11GLCapabilities.setNumSamples(X11GLXGraphicsConfiguration.glXGetFBConfig(l2, l, 100001, intBuffer));
        }
        XRenderDirectFormat xRenderDirectFormat = null != xVisualInfo ? X11GLXGraphicsConfiguration.XVisual2XRenderMask(l2, xVisualInfo.getVisual()) : null;
        short s = null != xRenderDirectFormat ? xRenderDirectFormat.getAlphaMask() : (short)0;
        x11GLCapabilities.setBackgroundOpaque(0 >= s);
        if (!x11GLCapabilities.isBackgroundOpaque()) {
            x11GLCapabilities.setTransparentRedValue(xRenderDirectFormat.getRedMask());
            x11GLCapabilities.setTransparentGreenValue(xRenderDirectFormat.getGreenMask());
            x11GLCapabilities.setTransparentBlueValue(xRenderDirectFormat.getBlueMask());
            x11GLCapabilities.setTransparentAlphaValue(s);
        }
        x11GLCapabilities.setDoubleBuffered(X11GLXGraphicsConfiguration.glXGetFBConfig(l2, l, 5, intBuffer) != 0);
        x11GLCapabilities.setStereo(X11GLXGraphicsConfiguration.glXGetFBConfig(l2, l, 6, intBuffer) != 0);
        x11GLCapabilities.setHardwareAccelerated(X11GLXGraphicsConfiguration.glXGetFBConfig(l2, l, 32, intBuffer) != 32769);
        x11GLCapabilities.setRedBits(X11GLXGraphicsConfiguration.glXGetFBConfig(l2, l, 8, intBuffer));
        x11GLCapabilities.setGreenBits(X11GLXGraphicsConfiguration.glXGetFBConfig(l2, l, 9, intBuffer));
        x11GLCapabilities.setBlueBits(X11GLXGraphicsConfiguration.glXGetFBConfig(l2, l, 10, intBuffer));
        x11GLCapabilities.setAlphaBits(X11GLXGraphicsConfiguration.glXGetFBConfig(l2, l, 11, intBuffer));
        x11GLCapabilities.setAccumRedBits(X11GLXGraphicsConfiguration.glXGetFBConfig(l2, l, 14, intBuffer));
        x11GLCapabilities.setAccumGreenBits(X11GLXGraphicsConfiguration.glXGetFBConfig(l2, l, 15, intBuffer));
        x11GLCapabilities.setAccumBlueBits(X11GLXGraphicsConfiguration.glXGetFBConfig(l2, l, 16, intBuffer));
        x11GLCapabilities.setAccumAlphaBits(X11GLXGraphicsConfiguration.glXGetFBConfig(l2, l, 17, intBuffer));
        x11GLCapabilities.setDepthBits(X11GLXGraphicsConfiguration.glXGetFBConfig(l2, l, 12, intBuffer));
        x11GLCapabilities.setStencilBits(X11GLXGraphicsConfiguration.glXGetFBConfig(l2, l, 13, intBuffer));
        try {
            x11GLCapabilities.setPbufferFloatingPointBuffers(X11GLXGraphicsConfiguration.glXGetFBConfig(l2, l, 8368, intBuffer) != 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (X11GLCapabilities)GLGraphicsConfigurationUtil.fixWinAttribBitsAndHwAccel(x11GraphicsDevice, n3, x11GLCapabilities);
    }

    private static String glXGetFBConfigErrorCode(int n) {
        switch (n) {
            case 3: {
                return "GLX_NO_EXTENSION";
            }
            case 2: {
                return "GLX_BAD_ATTRIBUTE";
            }
        }
        return "Unknown error code " + n;
    }

    static int glXGetFBConfig(long l, long l2, int n, IntBuffer intBuffer) {
        if (l == 0L) {
            throw new GLException("No display connection");
        }
        int n2 = GLX.glXGetFBConfigAttrib(l, l2, n, intBuffer);
        if (n2 != 0) {
            throw new GLException("glXGetFBConfig(" + X11GLXGraphicsConfiguration.toHexString(n) + ") failed: error code " + X11GLXGraphicsConfiguration.glXGetFBConfigErrorCode(n2));
        }
        return intBuffer.get(intBuffer.position());
    }

    static int glXFBConfig2FBConfigID(long l, long l2) {
        IntBuffer intBuffer = Buffers.newDirectIntBuffer((int)1);
        return X11GLXGraphicsConfiguration.glXGetFBConfig(l, l2, 32787, intBuffer);
    }

    static long glXFBConfigID2FBConfig(long l, int n, int n2) {
        IntBuffer intBuffer = Buffers.newDirectIntBuffer((int[])new int[]{32787, n2, 0});
        IntBuffer intBuffer2 = Buffers.newDirectIntBuffer((int)1);
        intBuffer2.put(0, -1);
        PointerBuffer pointerBuffer = GLX.glXChooseFBConfig(l, n, intBuffer, intBuffer2);
        if (pointerBuffer == null || pointerBuffer.limit() < 1) {
            return 0L;
        }
        return pointerBuffer.get(0);
    }

    static XVisualInfo XVisualID2XVisualInfo(long l, long l2) {
        int[] nArray = new int[1];
        XVisualInfo xVisualInfo = XVisualInfo.create();
        xVisualInfo.setVisualid(l2);
        XVisualInfo[] xVisualInfoArray = X11Lib.XGetVisualInfo(l, 1L, xVisualInfo, nArray, 0);
        if (xVisualInfoArray == null || xVisualInfoArray.length == 0) {
            return null;
        }
        XVisualInfo xVisualInfo2 = XVisualInfo.create(xVisualInfoArray[0]);
        if (DEBUG) {
            System.err.println("Fetched XVisualInfo for visual ID " + X11GLXGraphicsConfiguration.toHexString(l2));
            System.err.println("Resulting XVisualInfo: visualid = " + X11GLXGraphicsConfiguration.toHexString(xVisualInfo2.getVisualid()));
        }
        return xVisualInfo2;
    }

    static X11GLCapabilities XVisualInfo2GLCapabilities(X11GraphicsDevice x11GraphicsDevice, GLProfile gLProfile, XVisualInfo xVisualInfo, int n, boolean bl) {
        IntBuffer intBuffer;
        int n2 = n & 0xB;
        if (0 == n2) {
            return null;
        }
        long l = x11GraphicsDevice.getHandle();
        int n3 = X11GLXGraphicsConfiguration.glXGetConfig(l, xVisualInfo, 1, intBuffer = Buffers.newDirectIntBuffer((int)1));
        if (n3 == 0) {
            if (DEBUG) {
                System.err.println("Visual (" + X11GLXGraphicsConfiguration.toHexString(xVisualInfo.getVisualid()) + ") does not support OpenGL");
            }
            return null;
        }
        n3 = X11GLXGraphicsConfiguration.glXGetConfig(l, xVisualInfo, 4, intBuffer);
        if (n3 == 0) {
            if (DEBUG) {
                System.err.println("Visual (" + X11GLXGraphicsConfiguration.toHexString(xVisualInfo.getVisualid()) + ") does not support RGBA");
            }
            return null;
        }
        X11GLCapabilities x11GLCapabilities = new X11GLCapabilities(xVisualInfo, gLProfile);
        x11GLCapabilities.setDoubleBuffered(X11GLXGraphicsConfiguration.glXGetConfig(l, xVisualInfo, 5, intBuffer) != 0);
        x11GLCapabilities.setStereo(X11GLXGraphicsConfiguration.glXGetConfig(l, xVisualInfo, 6, intBuffer) != 0);
        if (bl) {
            x11GLCapabilities.setSampleBuffers(X11GLXGraphicsConfiguration.glXGetConfig(l, xVisualInfo, 100000, intBuffer) != 0);
            x11GLCapabilities.setNumSamples(X11GLXGraphicsConfiguration.glXGetConfig(l, xVisualInfo, 100001, intBuffer));
        }
        XRenderDirectFormat xRenderDirectFormat = null != xVisualInfo ? X11GLXGraphicsConfiguration.XVisual2XRenderMask(l, xVisualInfo.getVisual()) : null;
        short s = null != xRenderDirectFormat ? xRenderDirectFormat.getAlphaMask() : (short)0;
        x11GLCapabilities.setBackgroundOpaque(0 >= s);
        if (!x11GLCapabilities.isBackgroundOpaque()) {
            x11GLCapabilities.setTransparentRedValue(xRenderDirectFormat.getRedMask());
            x11GLCapabilities.setTransparentGreenValue(xRenderDirectFormat.getGreenMask());
            x11GLCapabilities.setTransparentBlueValue(xRenderDirectFormat.getBlueMask());
            x11GLCapabilities.setTransparentAlphaValue(s);
        }
        x11GLCapabilities.setHardwareAccelerated(true);
        x11GLCapabilities.setDepthBits(X11GLXGraphicsConfiguration.glXGetConfig(l, xVisualInfo, 12, intBuffer));
        x11GLCapabilities.setStencilBits(X11GLXGraphicsConfiguration.glXGetConfig(l, xVisualInfo, 13, intBuffer));
        x11GLCapabilities.setRedBits(X11GLXGraphicsConfiguration.glXGetConfig(l, xVisualInfo, 8, intBuffer));
        x11GLCapabilities.setGreenBits(X11GLXGraphicsConfiguration.glXGetConfig(l, xVisualInfo, 9, intBuffer));
        x11GLCapabilities.setBlueBits(X11GLXGraphicsConfiguration.glXGetConfig(l, xVisualInfo, 10, intBuffer));
        x11GLCapabilities.setAlphaBits(X11GLXGraphicsConfiguration.glXGetConfig(l, xVisualInfo, 11, intBuffer));
        x11GLCapabilities.setAccumRedBits(X11GLXGraphicsConfiguration.glXGetConfig(l, xVisualInfo, 14, intBuffer));
        x11GLCapabilities.setAccumGreenBits(X11GLXGraphicsConfiguration.glXGetConfig(l, xVisualInfo, 15, intBuffer));
        x11GLCapabilities.setAccumBlueBits(X11GLXGraphicsConfiguration.glXGetConfig(l, xVisualInfo, 16, intBuffer));
        x11GLCapabilities.setAccumAlphaBits(X11GLXGraphicsConfiguration.glXGetConfig(l, xVisualInfo, 17, intBuffer));
        return (X11GLCapabilities)GLGraphicsConfigurationUtil.fixWinAttribBitsAndHwAccel(x11GraphicsDevice, n2, x11GLCapabilities);
    }

    private static String glXGetConfigErrorCode(int n) {
        switch (n) {
            case 3: {
                return "GLX_NO_EXTENSION";
            }
            case 1: {
                return "GLX_BAD_SCREEN";
            }
            case 2: {
                return "GLX_BAD_ATTRIBUTE";
            }
            case 4: {
                return "GLX_BAD_VISUAL";
            }
        }
        return "Unknown error code " + n;
    }

    static int glXGetConfig(long l, XVisualInfo xVisualInfo, int n, IntBuffer intBuffer) {
        if (l == 0L) {
            throw new GLException("No display connection");
        }
        int n2 = GLX.glXGetConfig(l, xVisualInfo, n, intBuffer);
        if (n2 != 0) {
            throw new GLException("glXGetConfig(" + X11GLXGraphicsConfiguration.toHexString(n) + ") failed: error code " + X11GLXGraphicsConfiguration.glXGetConfigErrorCode(n2));
        }
        return intBuffer.get(intBuffer.position());
    }

    @Override
    public String toString() {
        return "X11GLXGraphicsConfiguration[" + this.getScreen() + ", visualID " + X11GLXGraphicsConfiguration.toHexString(this.getXVisualID()) + ", fbConfigID " + X11GLXGraphicsConfiguration.toHexString(this.getFBConfigID()) + ",\n\trequested " + this.getRequestedCapabilities() + ",\n\tchosen    " + this.getChosenCapabilities() + "]";
    }
}

