/*
 * Decompiled with CFR 0.152.
 */
package processing.video;

import java.io.File;
import java.lang.reflect.Method;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PImage;
import quicktime.QTException;
import quicktime.QTSession;
import quicktime.io.QTFile;
import quicktime.qd.Pict;
import quicktime.qd.PixMap;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDRect;
import quicktime.std.StdQTException;
import quicktime.std.movies.media.DataRef;
import quicktime.util.EndianOrder;
import quicktime.util.QTHandle;
import quicktime.util.QTHandleRef;
import quicktime.util.RawEncodedImage;

public class Movie
extends PImage
implements PConstants,
Runnable {
    Method movieEventMethod;
    String filename;
    Thread runner;
    PImage borderImage;
    boolean removeBorders = true;
    boolean play;
    boolean repeat;
    boolean available;
    int fps;
    public quicktime.std.movies.Movie movie;
    QDRect movieRect;
    QDGraphics movieGraphics;
    boolean firstFrame = true;
    RawEncodedImage raw;

    public Movie(PApplet parent, String filename) {
        this(parent, filename, 30);
    }

    public Movie(PApplet parent, String filename, int ifps) {
        super(1, 1, 1);
        this.init(parent, filename, ifps);
    }

    public void init(PApplet parent, String filename, int fps) {
        block20: {
            this.parent = parent;
            this.fps = fps;
            try {
                QTSession.open();
            }
            catch (QTException e) {
                e.printStackTrace();
                return;
            }
            try {
                File file2;
                try {
                    file2 = new File(parent.dataPath(filename));
                    if (file2.exists()) {
                        this.movie = this.fromDataRef(new DataRef(new QTFile(file2)));
                    }
                }
                catch (Exception file2) {
                    // empty catch block
                }
                if (this.movie != null) break block20;
                try {
                    file2 = new File(filename);
                    if (file2.exists()) {
                        this.movie = this.fromDataRef(new DataRef(new QTFile(file2)));
                    }
                }
                catch (QTException file3) {}
            }
            catch (SecurityException file3) {
                // empty catch block
            }
        }
        if (this.movie == null) {
            byte[] data = parent.loadBytes(filename);
            try {
                this.movie = this.fromDataRef(new DataRef((QTHandleRef)new QTHandle(data)));
            }
            catch (QTException e) {
                e.printStackTrace();
            }
        }
        if (this.movie == null) {
            parent.die("Could not find movie file " + filename, null);
        }
        try {
            this.movie.preroll(0, 1.0f);
            while (this.movie.maxLoadedTimeInMovie() == 0) {
                this.movie.task(100);
            }
            this.movie.setRate(1.0f);
            parent.registerDispose((Object)this);
            try {
                this.movieEventMethod = parent.getClass().getMethod("movieEvent", Movie.class);
            }
            catch (Exception data) {
                // empty catch block
            }
            this.runner = new Thread(this);
            this.runner.start();
        }
        catch (QTException qte) {
            qte.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private quicktime.std.movies.Movie fromDataRef(DataRef ref) throws QTException {
        return quicktime.std.movies.Movie.fromDataRef((DataRef)ref, (int)257);
    }

    public boolean available() {
        return this.available;
    }

    public void read() {
        try {
            if (this.firstFrame) {
                this.movieRect = this.movie.getBox();
                this.movieGraphics = EndianOrder.isNativeLittleEndian() ? new QDGraphics(1111970369, this.movieRect) : new QDGraphics(QDGraphics.kDefaultPixelFormat, this.movieRect);
            }
            Pict pict = this.movie.getPict(this.movie.getTime());
            pict.draw(this.movieGraphics, this.movieRect);
            PixMap pixmap = this.movieGraphics.getPixMap();
            this.raw = pixmap.getPixelData();
            if (this.firstFrame) {
                int movieWidth = this.movieRect.getWidth();
                int movieHeight = this.movieRect.getHeight();
                int j = this.raw.getRowBytes() - movieWidth * 4;
                int k = j / 4;
                int dataWidth = movieWidth + k;
                if (dataWidth != movieWidth) {
                    if (this.removeBorders) {
                        this.borderImage = new PImage(dataWidth, movieHeight, 1);
                    } else {
                        movieWidth = dataWidth;
                    }
                }
                super.init(movieWidth, movieHeight, 1);
                this.firstFrame = false;
            }
            this.loadPixels();
            if (this.borderImage != null) {
                this.raw.copyToArray(0, this.borderImage.pixels, 0, this.borderImage.width * this.borderImage.height);
                int borderIndex = 0;
                int targetIndex = 0;
                int i = 0;
                while (i < this.height) {
                    System.arraycopy(this.borderImage.pixels, borderIndex, this.pixels, targetIndex, this.width);
                    borderIndex += this.borderImage.width;
                    targetIndex += this.width;
                    ++i;
                }
            } else {
                this.raw.copyToArray(0, this.pixels, 0, this.width * this.height);
            }
            this.updatePixels();
        }
        catch (QTException qte) {
            qte.printStackTrace();
        }
    }

    public void play() {
        this.play = true;
    }

    public void loop() {
        this.play();
        this.repeat = true;
    }

    public void noLoop() {
        this.repeat = false;
    }

    public void pause() {
        this.play = false;
    }

    public void stop() {
        this.play = false;
        try {
            this.movie.setTimeValue(0);
        }
        catch (StdQTException e) {
            this.errorMessage("stop", (Exception)((Object)e));
        }
    }

    public void frameRate(int ifps) {
        if (ifps <= 0) {
            System.err.println("Movie: ignoring bad frame rate of " + ifps + " fps.");
        } else {
            this.fps = ifps;
        }
    }

    public void speed(float rate) {
        try {
            this.movie.setRate(rate);
        }
        catch (StdQTException e) {
            this.errorMessage("speed", (Exception)((Object)e));
        }
    }

    public float time() {
        try {
            return (float)this.movie.getTime() / (float)this.movie.getTimeScale();
        }
        catch (StdQTException e) {
            this.errorMessage("time", (Exception)((Object)e));
            return -1.0f;
        }
    }

    public void jump(float where) {
        try {
            int scaledTime = (int)(where * (float)this.movie.getTimeScale());
            this.movie.setTimeValue(scaledTime);
        }
        catch (StdQTException e) {
            this.errorMessage("jump", (Exception)((Object)e));
        }
    }

    public float duration() {
        try {
            return (float)this.movie.getDuration() / (float)this.movie.getTimeScale();
        }
        catch (StdQTException e) {
            this.errorMessage("length", (Exception)((Object)e));
            return -1.0f;
        }
    }

    public void run() {
        while (Thread.currentThread() == this.runner) {
            try {
                Thread.sleep(1000 / this.fps);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.play) continue;
            this.available = true;
            if (this.movieEventMethod == null) {
                this.read();
            } else {
                try {
                    this.movieEventMethod.invoke((Object)this.parent, this);
                }
                catch (Exception e) {
                    System.err.println("error, disabling movieEvent() for " + this.filename);
                    e.printStackTrace();
                    this.movieEventMethod = null;
                }
            }
            try {
                if (!this.movie.isDone() || !this.repeat) continue;
                this.movie.goToBeginning();
            }
            catch (StdQTException e) {
                this.play = false;
                this.errorMessage("rewinding", (Exception)((Object)e));
            }
        }
    }

    public void dispose() {
        this.stop();
        this.runner = null;
        QTSession.close();
    }

    protected void errorMessage(String where, Exception e) {
        this.parent.die("Error inside Movie." + where + "()", e);
    }
}

